#!/usr/bin/python
# Outputs a sector image read from stdin and replaces hex values with their printable characters
# 
# Intended to be used with an mbed to interface to the HP 4145A's disk controller.
# See http://www.kitsune-denshi.net/equipment:hp4145a for a description
import serial
import sys
import time


for line in sys.stdin:


    temp = line.rstrip().split(':')
    track = int(temp[0])
    sector = int(temp[1])

    data = temp[2].split(' ')


    out_str = ''

    for d in data:
    	data_int = int(d, 16)

    	if (data_int >= 32 and data_int <= 126):
    		out_str += chr(data_int) + ' '
    	else:
    		out_str += d

    	out_str += ' '


    print("{:02d}:{:02d}:".format(track, sector)  + out_str)

