#!/usr/bin/python
# Reads individual sectors from a disk to stdout.
# 
# Intended to be used with an mbed to interface to the HP 4145A's disk controller.
# See http://www.kitsune-denshi.net/equipment:hp4145a for a description
import serial
import sys
import time

with serial.Serial('/dev/ttyACM0', 115200, timeout=5) as ser:


    print("Initialising...", file = sys.stderr)

    ser.reset_input_buffer()

    #release controller from reset
    ser.write(b"1\n")
    time.sleep(0.1)

    #select controller
    ser.write(b"4\n")
    time.sleep(0.1)

    #enable drive
    ser.write(b"5\n")
    time.sleep(1)

    #reset drive
    ser.write(b"w\n00 03\n")  
    time.sleep(5)

    #read status
    ser.write(b"r\n00\n")  

    print("Status register = {}".format(ser.readline().decode("utf-8").rstrip()), file = sys.stderr)


    for i in range(0, 40):

        #seek to track
        ser.write(bytes("w\n03 {:02X}\n".format(i), "utf-8"))
        ser.write(b"w\n00 1B\n")
        time.sleep(0.1)


        for j in range(1, 10):
            print("Reading track {}, sector {}".format(i, j), file = sys.stderr)

            #load sector register
            ser.write(bytes("w\n02 {:02X}\n".format(j), "utf-8"))

            #clear buffer
            ser.write(b"c\n")

            #read track
            ser.write(b"Q\n")

            bytes_read = int(ser.readline().decode("utf-8").rstrip())

            print("{} bytes read from disk.".format(bytes_read), file = sys.stderr)

            #read status
            ser.write(b"r\n00\n")  
            status = ser.readline().decode("utf-8").rstrip()
            print("Status register = {}".format(status), file = sys.stderr)

            #read buffer
            ser.write(b"o\n")        
            print("{:02d}:{:02d}:".format(i,j) + ser.readline().decode("utf-8").rstrip())    

        #move to next track
        ser.write(b"w\n00 5B\n")
        time.sleep(0.25)


    #reset drive
    ser.write(b"w\n00 03\n")  
    time.sleep(5)

    #disable drive
    ser.write(b"6\n")

    #turn off controller
    ser.write(b"2\n")
    ser.write(b"3\n")









